local path = Path.point{x = -0.9, y = -0.2}
    :addLine{x = -0.3, y = -0.9}
    :addLine{x = 0.1, y = -0.9}
    :addLine{x = 0.9, y = 0.7}
    :addLine{x = 0.7, y = 0.9}
    :addLine{x = -0.1, y = -0.5}
    :addLine{x = -0.6, y = 0.1}
    :closeSubpath()

CheckMarkStamp = function(canvas, rect, value, paint)
    if value then
        local size = math.min(rect.right - rect.left, rect.top - rect.bottom) / 2
        local cx = (rect.left + rect.right) / 2
        local cy = (rect.bottom + rect.top) / 2
        local transformation = Transformation:identity():translate(cx, cy):scale(size/2)
        canvas:setPaint(paint):concatTransformation(transformation):fill(path)
    end
end

return CheckMarkStamp
